﻿/*
TRIGGERS
	equip
	unequip
	initPlayer
	attackEnemy
	hurtPlayer
	initPlayer
	loop
	playerSubWeapon
	enemyStun
	playerStun
	playerState
*/
_global.EQUIP = {
	weapon:{},
	subWeapon:{},
	armor:{},
	accessory:{}
}// EQUIP
#include "defineEquipment/weapons.as"
#include "defineEquipment/subWeapons.as"
#include "defineEquipment/armor.as"
#include "defineEquipment/accessories.as"

// pass-through triggers
// called when an item is unequipped and before the new item is equipped
EQUIP.unequip = function(){
	// reset stats
	var weapName = RAM.player.equip.weapon;
	var subWeapName = RAM.player.equip.subWeapon;
	var armorName = RAM.player.equip.armor;
	RAM.player.attack = ROM.misc.playerAttack +(ROM.items.weapon[weapName].potency||0);
	RAM.player.subAttack = ROM.misc.playerAttack +(ROM.items.subWeapon[subWeapName].potency||0);
	RAM.player.defense = ROM.misc.playerDefense +(ROM.items.armor[armorName].potency||0);
	// apply effects
	var thisName = RAM.player.equip.weapon;
	EQUIP.weapon[thisName].unequip();
	var thisName = RAM.player.equip.subWeapon;
	EQUIP.subWeapon[thisName].unequip();
	var thisName = RAM.player.equip.armor;
	EQUIP.armor[thisName].unequip();
	var thisName = RAM.player.equip.accessory;
	EQUIP.accessory[thisName].unequip();
}// unequip() trigger

// called when an item is equipped
EQUIP.equip = function(){
	// reset stats
	var weapName = RAM.player.equip.weapon;
	var subWeapName = RAM.player.equip.subWeapon;
	var armorName = RAM.player.equip.armor;
	RAM.player.attack = ROM.misc.playerAttack +(ROM.items.weapon[weapName].potency||0);
	RAM.player.subAttack = ROM.misc.playerAttack +(ROM.items.subWeapon[subWeapName].potency||0);
	RAM.player.defense = ROM.misc.playerDefense +(ROM.items.armor[armorName].potency||0);
	// apply effects
	var thisName = RAM.player.equip.weapon;
	EQUIP.weapon[thisName].equip();
	var thisName = RAM.player.equip.subWeapon;
	EQUIP.subWeapon[thisName].equip();
	var thisName = RAM.player.equip.armor;
	EQUIP.armor[thisName].equip();
	var thisName = RAM.player.equip.accessory;
	EQUIP.accessory[thisName].equip();
}// equip() trigger

// called when an enemy is hurt
EQUIP.attackEnemy = function(enemy_mc, damage, attackingSprite_mc){
	var thisName = RAM.player.equip.weapon;
	EQUIP.weapon[thisName].attackEnemy(enemy_mc, damage, attackingSprite_mc);
	var thisName = RAM.player.equip.subWeapon;
	EQUIP.subWeapon[thisName].attackEnemy(enemy_mc, damage, attackingSprite_mc);
	var thisName = RAM.player.equip.armor;
	EQUIP.armor[thisName].attackEnemy(enemy_mc, damage, attackingSprite_mc);
	var thisName = RAM.player.equip.accessory;
	EQUIP.accessory[thisName].attackEnemy(enemy_mc, damage, attackingSprite_mc);
}// attackEnemy() trigger

// called when the player flinches
EQUIP.hurtPlayer = function( damage, hazardType ){
	var thisName = RAM.player.equip.weapon;
	EQUIP.weapon[thisName].hurtPlayer( damage, hazardType );
	var thisName = RAM.player.equip.subWeapon;
	EQUIP.subWeapon[thisName].hurtPlayer( damage, hazardType );
	var thisName = RAM.player.equip.armor;
	EQUIP.armor[thisName].hurtPlayer( damage, hazardType );
	var thisName = RAM.player.equip.accessory;
	EQUIP.accessory[thisName].hurtPlayer( damage, hazardType );
}// hurtPlayer() trigger

// called when the player is placed in a map
EQUIP.initPlayer = function(){
	var thisName = RAM.player.equip.weapon;
	EQUIP.weapon[thisName].initPlayer();
	var thisName = RAM.player.equip.subWeapon;
	EQUIP.subWeapon[thisName].initPlayer();
	var thisName = RAM.player.equip.armor;
	EQUIP.armor[thisName].initPlayer();
	var thisName = RAM.player.equip.accessory;
	EQUIP.accessory[thisName].initPlayer();
}// initPlayer() trigger

// called each frame
EQUIP.loop = function(){
	var thisName = RAM.player.equip.weapon;
	EQUIP.weapon[thisName].loop();
	var thisName = RAM.player.equip.subWeapon;
	EQUIP.subWeapon[thisName].loop();
	var thisName = RAM.player.equip.armor;
	EQUIP.armor[thisName].loop();
	var thisName = RAM.player.equip.accessory;
	EQUIP.accessory[thisName].loop();
}// loop() trigger





// called when player subWeapon is placed
EQUIP.playerSubWeapon = function( weap_ref ){
	var thisName = RAM.player.equip.weapon;
	EQUIP.weapon[thisName].playerSubWeapon( weap_ref );
	var thisName = RAM.player.equip.subWeapon;
	EQUIP.subWeapon[thisName].playerSubWeapon( weap_ref );
	var thisName = RAM.player.equip.armor;
	EQUIP.armor[thisName].playerSubWeapon( weap_ref );
	var thisName = RAM.player.equip.accessory;
	EQUIP.accessory[thisName].playerSubWeapon( weap_ref );
}// playerSubWeapon() trigger

// called when an enemy recieves a taunt
EQUIP.enemyStun = function( enemy_ref ){
	var thisName = RAM.player.equip.weapon;
	EQUIP.weapon[thisName].enemyStun( enemy_ref );
	var thisName = RAM.player.equip.subWeapon;
	EQUIP.subWeapon[thisName].enemyStun( enemy_ref );
	var thisName = RAM.player.equip.armor;
	EQUIP.armor[thisName].enemyStun( enemy_ref );
	var thisName = RAM.player.equip.accessory;
	EQUIP.accessory[thisName].enemyStun( enemy_ref );
}// enemyStun() trigger

// called when the player recieves a taunt
EQUIP.playerStun = function( enemy_ref ){
	var thisName = RAM.player.equip.weapon;
	EQUIP.weapon[thisName].playerStun( enemy_ref );
	var thisName = RAM.player.equip.subWeapon;
	EQUIP.subWeapon[thisName].playerStun( enemy_ref );
	var thisName = RAM.player.equip.armor;
	EQUIP.armor[thisName].playerStun( enemy_ref );
	var thisName = RAM.player.equip.accessory;
	EQUIP.accessory[thisName].playerStun( enemy_ref );
}// playerStun() trigger

// called then the player changes state
EQUIP.playerState = function( newState ){
	var thisName = RAM.player.equip.weapon;
	EQUIP.weapon[thisName].playerState( newState );
	var thisName = RAM.player.equip.subWeapon;
	EQUIP.subWeapon[thisName].playerState( newState );
	var thisName = RAM.player.equip.armor;
	EQUIP.armor[thisName].playerState( newState );
	var thisName = RAM.player.equip.accessory;
	EQUIP.accessory[thisName].playerState( newState );
}// playerState() trigger
